
 /**************************************************************************
  **************************************************************************

   A C++ Program to illustrate the implementation of linked list as a Queue.

  **************************************************************************
  **************************************************************************/
 /*************************************************************************

	  By :
		Muhammad Tahir Shahzad  [ MTS ]
		B.C.S Honours  [ 2000-04 ]
		Government College University Lahore
		Pakistan

      E-mail :  mtshome@wol.net.pk

    Web-Site :  www.mts-home.cjb.net  [ www.wol.net.pk/mtshome ]
		www.mtshome.cjb.net   [ www.geocities.com/mtahirshahzad ]

  *************************************************************************/

 /**************************************************************************/
 /**************************************************************************/
 //----------------------  HEADER FILES  ----------------------------------//
 /**************************************************************************/
 /**************************************************************************/

 # include <iostream.h>
 # include <graphics.h>
 # include <stdlib.h>
 # include <conio.h>
 # include <dos.h>

 /**************************************************************************/
 /**************************************************************************/
 //----------------------  CONSTANT VARIABLES  ----------------------------//
 /**************************************************************************/
 /**************************************************************************/

 # define INSERT 0
 # define DELETE 1

 # define NORMAL 0
 # define WARNING 1

 /**************************************************************************/
 /**************************************************************************/
 //----------------------  CLASS DEFINITION  ------------------------------//
 /**************************************************************************/
 /**************************************************************************/

 class Linked_list_Queue
	{
	   private:
		char fill_pattern[8];

		int inserted_element_count;

		struct node
			{
			   long data;
			   node *next;
			};

		node *rear;
		node *entry;
		node *print;
		node *front;

	   public:
		Linked_list_Queue( );

		long get_element( );

		void Delete( );
		void Insert( );
		void print_linked_list( );
		void show_working( );
		void show_main_screen( );
		void waiting_for_input( );
		void show_element_screen(int);
		void clear_element_screen(int);
		void show_linked_list_screen( );
		void show_output_screen(int);
		void show_window(int,int,int,int);
	};

 /**************************************************************************/
 /**************************************************************************/
 //---------------------  FUNCTION DEFINITIONS  ---------------------------//
 /**************************************************************************/
 /**************************************************************************/

 /**************************************************************************/
 //----------------------  Linked_list_Queue( )  --------------------------//
 /**************************************************************************/

 Linked_list_Queue::Linked_list_Queue ( )
    {
       rear=NULL;
       front=NULL;
       inserted_element_count=0;

       fill_pattern[0]=0xAA;
       fill_pattern[1]=0x55;
       fill_pattern[2]=0xAA;
       fill_pattern[3]=0x55;
       fill_pattern[4]=0xAA;
       fill_pattern[5]=0x55;
       fill_pattern[6]=0xAA;
       fill_pattern[7]=0x55;
    }

 /**************************************************************************/
 //--------------------  show_window(int,int,int,int)  --------------------//
 /**************************************************************************/

 void Linked_list_Queue::show_window(int x_1,int y_1,int x_2,int y_2)
    {
       setcolor(15);
	 rectangle(x_1,y_1,x_2,y_2);
	 rectangle(x_1+1,y_1+1,x_2-1,y_2-1);

       setcolor(7);
	 rectangle(x_1+2,y_1+2,x_2-2,y_2-2);
	 rectangle(x_1+3,y_1+3,x_2-3,y_2-3);
	 rectangle(x_1+4,y_1+4,x_2-4,y_2-4);

       setcolor(8);
	 rectangle(x_1+5,y_1+5,x_2-5,y_2-5);
	 rectangle(x_1+6,y_1+6,x_2-6,y_2-6);
	 rectangle(x_1+7,y_1+7,x_2-7,y_2-7);
    }

 /**************************************************************************/
 //----------------------  show_main_screen( )  ---------------------------//
 /**************************************************************************/

 void Linked_list_Queue ::show_main_screen( )
    {
       setcolor(15);
       setlinestyle(1,0,3);
	 rectangle(5,5,getmaxx( )-5,getmaxy( )-5);

       setlinestyle(0,0,0);

       show_window(5,5,getmaxx( )-5,80);

       setfillpattern(fill_pattern,4);
	 bar(13,13,getmaxx( )-13,72);

       settextstyle(3,0,4);
	 setcolor(0);
	   outtextxy(17,22,"Implementation of Linked List as Queue");
	   outtextxy(18,22,"Implementation of Linked List as Queue");

	 setcolor(14);
	   outtextxy(19,20,"Implementation of Linked List as Queue");
	   outtextxy(20,20,"Implementation of Linked List as Queue");
	   outtextxy(21,20,"Implementation of Linked List as Queue");

       show_window(5,82,305,getmaxy( )-5);

       setfillpattern(fill_pattern,9);
	 bar(14,91,296,getmaxy( )-14);

       setcolor(6);
       setfillstyle(1,6);
	 pieslice(215,105,0,360,10);

       setcolor(2);
       setfillstyle(1,2);
	 pieslice(245,105,0,360,10);

       setcolor(4);
       setfillstyle(1,4);
	 pieslice(275,105,0,360,10);

       setcolor(7);
	 circle(215,105,11);
	 circle(245,105,11);
	 circle(275,105,11);

       show_window(307,82,getmaxx( )-5,getmaxy( )-5);

       settextstyle(7,0,4);
	 setcolor(0);
	   outtextxy(16,111,"Press:");

	 setcolor(10);
	   outtextxy(17,110,"Press:");
	   outtextxy(18,110,"Press:");

       settextstyle(2,0,6);
	 setcolor(0);
	   outtextxy(59,151,"<I> to Insert an Element");
	   outtextxy(59,171,"<D> to Delete an Element");
	   outtextxy(59,191,"<E> to Exit");

	 setcolor(14);
	   outtextxy(60,150,"<I> to Insert an Element");
	   outtextxy(61,150,"<I> to Insert an Element");

	   outtextxy(60,170,"<D> to Delete an Element");
	   outtextxy(61,170,"<D> to Delete an Element");

	   outtextxy(60,190,"<E> to Exit");
	   outtextxy(61,190,"<E> to Exit");

       setfillstyle(2,1);
	 bar(317,92,getmaxx( )-15,getmaxy( )-15);
    }

 /**************************************************************************/
 //---------------------  show_linked_list_screen( )  ---------------------//
 /**************************************************************************/

 void Linked_list_Queue::show_linked_list_screen( )
    {
       for(int count=0;count<=187;count++)
	  {
	     setfillstyle(1,0);
	       bar(317,280,getmaxx( )-15,278-count);
	       bar(317,280,getmaxx( )-15,278+count);

	     delay(5);
	  }

       setcolor(12);
       settextstyle(2,0,7);
	 outtextxy(405,400,"Linked List (Queue)");
	 outtextxy(406,400,"Linked List (Queue)");
	 outtextxy(407,400,"Linked List (Queue)");

       setfillstyle(1,6);
	 bar(402,420,618,422);

       setcolor(15);
       setlinestyle(0,0,3);
	 rectangle(330,405,390,435);

       setfillstyle(1,9);
	 bar(331,406,374,434);

       setfillstyle(1,1);
	 bar(376,406,389,434);

	 line(375,405,375,435);

       setcolor(7);
       setlinestyle(0,0,0);
	 line(352,425,352,455);  /* Entry->Data pointing arrow */
	 line(352,455,415,455);

	 line(412,452,415,455);
	 line(412,458,415,455);

	 line(382,423,382,443);   /* Entry->Next pointing arrow */
	 line(382,443,415,443);

	 line(412,440,415,443);
	 line(412,446,415,443);

       setfillstyle(1,15);
	 pieslice(382,420,0,360,2);

       settextstyle(0,0,1);
	 setcolor(15);
	   outtextxy(320,402,"*");

	 setcolor(9);
	   outtextxy(420,452,"Entry->Data");
	   outtextxy(420,438,"Entry->Next (x=NULL)");

	 setcolor(11);
	   outtextxy(333,417,"00000");
    }

 /**************************************************************************/
 //-----------------------  show_output_screen(int)  ----------------------//
 /**************************************************************************/

 void Linked_list_Queue::show_output_screen(int NORMAL_WARNING)
    {
       int x_1;
       int x_2;
       int y_1;
       int y_2;

       if(NORMAL_WARNING==NORMAL)
	  {
	     x_1=20;
	     x_2=280;
	     y_1=277;
	     y_2=350;
	  }

       if(NORMAL_WARNING==WARNING)
	  {
	     x_1=20;
	     x_2=280;
	     y_1=277;
	     y_2=367;
	  }

       setcolor(15);
       setlinestyle(1,0,3);
	 rectangle(x_1,y_1,x_2,y_2);

       setlinestyle(0,0,0);

       setcolor(15);
	 rectangle(x_1,y_1,x_2,y_2);

       setcolor(7);
	 rectangle(x_1+1,y_1+1,x_2-1,y_2-1);

       setcolor(8);
	 rectangle(x_1+2,y_1+2,x_2-2,y_2-2);

       setfillstyle(1,9);
	 bar(x_1+3,y_1+3,x_2-3,y_2-3);
    }

 /**************************************************************************/
 //----------------------  show_element_screen(int)  ----------------------//
 /**************************************************************************/

 void Linked_list_Queue::show_element_screen(int INSERT_DELETE)
    {
       show_output_screen(NORMAL);

       if(INSERT_DELETE==INSERT)
	  {
	     settextstyle(2,0,6);
	       setcolor(0);
		 outtextxy(28,281,"Enter the Element :");

	       setcolor(11);
		 outtextxy(29,280,"Enter the Element :");
		 outtextxy(30,280,"Enter the Element :");
	  }

       else if(INSERT_DELETE==DELETE)
	  {
	     settextstyle(2,0,6);
	       setcolor(0);
		 outtextxy(28,281,"Deleted Element is :");

	       setcolor(11);
		 outtextxy(29,280,"Deleted Element is :");
		 outtextxy(30,280,"Deleted Element is :");
	  }

       delay(300);

       for(int count=1;count<=65;count++)
	  {
	     setcolor(0);
	     setfillstyle(1,0);
	       bar(180-count,306,180+count,330);

	       pieslice(180-count,318,0,360,12);
	       pieslice(180+count,318,0,360,12);

	     setcolor(15);
	       line(180-count,302,180+count,302);
	       line(180-count,334,180+count,334);

	       arc(180-count,318,90,270,16);
	       arc(180+count,318,270,90,16);

	     setcolor(7);
	       arc(180-count,318,90,270,15);
	       arc(180-count,318,90,270,14);

	       line(180-count,303,180+count,303);
	       line(180-count,304,180+count,304);

	       line(180-count,333,180+count,333);
	       line(180-count,332,180+count,332);

	       arc(180+count,318,270,90,15);
	       arc(180+count,318,270,90,14);

	     setcolor(8);
	       line(180-count,305,180+count,305);
	       line(180-count,331,180+count,331);

	       arc(180-count,318,90,270,13);
	       arc(180+count,318,270,90,13);

	     delay(4);
	  }
    }

 /**************************************************************************/
 //-------------------  clear_element_screen(int)  ------------------------//
 /**************************************************************************/

 void Linked_list_Queue::clear_element_screen(int NORMAL_WARNING)
    {
       if(NORMAL_WARNING==WARNING)
	 {
	     for(int count=1;count<=50;count++)
		{
		   setfillpattern(fill_pattern,9);
		     bar(18,275,290,275+count);
		     bar(18,375,290,375-count);

		   delay(20);
		}
	  }

       else if(NORMAL_WARNING==NORMAL)
	  {
	     for(int count=1;count<=40;count++)
		{
		   setfillpattern(fill_pattern,9);
		     bar(18,275,290,275+count);
		     bar(18,355,290,355-count);

		   delay(20);
		}
	  }
    }

 /**************************************************************************/
 //----------------------------  get_element( )  --------------------------//
 /**************************************************************************/

 long Linked_list_Queue::get_element( )
    {
       show_element_screen(INSERT);

       int count=0;
       char string[6]={'\0'};

       do
	  {
	     int key_code=0;

	     char key=NULL;

	     if(kbhit( ))
		key=getch( );

	     key_code=int(key);

	     if(key_code>=48 && key_code<=57)
		{
		   string[count]=key;
		   count++;
		}

	     else if(key_code==8 && count>0)
		{
		   setfillstyle(1,0);
		     bar(130,306,230,330);

		   count--;
		   string[count]='\0';
		}

	     else if(key_code==13 && count>0)
		break;

	     setcolor(12);
	     settextstyle(2,0,7);

	       moveto(140,305);
		 outtext(string);

	       moveto(141,305);
		 outtext(string);

	     int x=getx( );
	     int y=305;

	     while(!kbhit( ))
		{
		   settextstyle(2,0,7);
		     setcolor(12);
		       moveto(x+2,y);
			 outtext("_");

		   delay(250);

		     setcolor(0);
		       moveto(x+2,y);
			 outtext("_");

		   delay(200);
	       }
	  }
       while(count<5);

       if(count==5)
	  while(int(getch( ))!=13);

       long element=atol(string);

       clear_element_screen(NORMAL);

       return element;
    }

 /**************************************************************************/
 //-----------------------------  Insert( )  ------------------------------//
 /**************************************************************************/

 void Linked_list_Queue::Insert( )
    {
       long num=get_element( );

       for(int count=1;count<5;count++)
	  {
	     setcolor(0);
	     setfillstyle(1,0);
	       pieslice(215,105,0,360,10);

	     delay(250);

	     setcolor(6);
	     setfillstyle(1,6);
	       pieslice(215,105,0,360,10);

	     delay(300);
	  }

       if(inserted_element_count<15)
	  {
	     setcolor(10);
	     setfillstyle(1,10);
	       pieslice(245,105,0,360,10);

	     sound(1500);
	     delay(800);
	     nosound( );

	     setcolor(2);
	     setfillstyle(1,2);
	       pieslice(245,105,0,360,10);
	  }

       if(inserted_element_count==15)
	  {
	     setcolor(12);
	     setfillstyle(1,12);
	       pieslice(275,105,0,360,10);

	     sound(2500);
	     delay(1000);
	     nosound( );

	     setcolor(4);
	     setfillstyle(1,4);
	       pieslice(275,105,0,360,10);

	     delay(200);
	  }

       entry=new(node);

       if(inserted_element_count==15)
	  {
	     show_output_screen(WARNING);

	     settextstyle(7,0,4);
	       setcolor(0);
		 outtextxy(25,277,"Error:");
		 outtextxy(26,277,"Error:");

	       setcolor(14);
		 outtextxy(27,275,"Error:");
		 outtextxy(28,275,"Error:");

	     while(!kbhit( ))
		{
		   settextstyle(2,0,8);
		     setcolor(0);
		       outtextxy(46,309,"Not enough heap");
		       outtextxy(47,309,"Not enough heap");

		       outtextxy(28,335,"space on Screen.");
		       outtextxy(29,335,"space on Screen.");

		     setcolor(12);
		       outtextxy(48,308,"Not enough heap");
		       outtextxy(49,308,"Not enough heap");
		       outtextxy(50,308,"Not enough heap");

		       outtextxy(30,334,"space on Screen.");
		       outtextxy(31,334,"space on Screen.");
		       outtextxy(32,334,"space on Screen.");

		   delay(500);

		   setfillstyle(1,9);
		     bar(23,315,277,362);

		   delay(400);
		}

	     getch( );
	     clear_element_screen(1);
	  }

       else if(rear==NULL)
	  {
	     entry->data=num;
	     entry->next=NULL;
	     rear=entry;
	     front=rear;
	     inserted_element_count++;
	  }

       else
	  {
	     entry->data=num;
	     entry->next=NULL;
	     rear->next=entry;
	     rear=entry;
	     inserted_element_count++;
	  }

       print_linked_list( );
    }

 /**************************************************************************/
 //---------------------------  Delete( )  --------------------------------//
 /**************************************************************************/

 void Linked_list_Queue::Delete( )
    {
       for(int count=1;count<5;count++)
	  {
	     setcolor(0);
	     setfillstyle(1,0);
	       pieslice(215,105,0,360,10);

	     delay(250);

	     setcolor(6);
	     setfillstyle(1,6);
	       pieslice(215,105,0,360,10);

	     delay(300);
	  }

       if(inserted_element_count==0)
	  {
	     setcolor(12);
	     setfillstyle(1,12);
	       pieslice(275,105,0,360,10);

	     sound(2500);
	     delay(1000);
	     nosound( );

	     setcolor(4);
	     setfillstyle(1,4);
	       pieslice(275,105,0,360,10);

	     delay(200);
	  }

       else if(inserted_element_count>0)
	  {
	     setcolor(10);
	     setfillstyle(1,10);
	       pieslice(245,105,0,360,10);

	     sound(3000);
	     delay(800);
	     nosound( );

	     setcolor(2);
	     setfillstyle(1,2);
	       pieslice(245,105,0,360,10);
	  }

       if(front==NULL)
	  {
	     show_output_screen(WARNING);

	     settextstyle(7,0,4);
	       setcolor(0);
		 outtextxy(25,277,"Error:");
		 outtextxy(26,277,"Error:");

	       setcolor(14);
		 outtextxy(27,275,"Error:");
		 outtextxy(28,275,"Error:");

	     while(!kbhit( ))
		{
		   settextstyle(6,0,4);
		     setcolor(0);
		       outtextxy(48,306,"Nothing to Delete");
		       outtextxy(49,306,"Nothing to Delete");

		     setcolor(12);
		       outtextxy(50,305,"Nothing to Delete");
		       outtextxy(51,305,"Nothing to Delete");
		       outtextxy(52,305,"Nothing to Delete");

		   delay(500);

		   setfillstyle(1,9);
		     bar(23,315,277,350);

		   delay(400);
		}
	     getch( );
	  }

       else
	  {
	     long Deleted_element=front->data;

	     node *temp;

	     temp=front;
	     front=front->next;
	     inserted_element_count--;

	     delete (temp);

	     char element[6]={'\0'};

	     ltoa(Deleted_element,element,10);

	     show_element_screen(DELETE);

	     setcolor(12);
	     settextstyle(2,0,7);
	       outtextxy(140,305,element);
	       outtextxy(141,305,element);

	     delay(2500);
	  }

       clear_element_screen(DELETE);
       print_linked_list( );
    }

 /**************************************************************************/
 //-----------------------  print_linked_list( )  -------------------------//
 /**************************************************************************/

 void Linked_list_Queue::print_linked_list( )
    {
       int count=0;
       int x=340;
       int y=100;

       print=front;

       setfillstyle(1,0);
	 bar(317,92,getmaxx( )-15,getmaxy( )-80);

       while(print!=NULL)
	  {
	     setcolor(15);
	     setlinestyle(0,0,3);
	       rectangle(x,y,x+60,y+30);

	     char element[6]={'\0'};

	     ltoa(print->data,element,10);

	     if(count==0 || count==1 || count==2 || count==6 || count==7 ||
			     count==8 || count==12 || count==13 || count==14)
		{
		   setfillstyle(1,9);
		     bar(x+1,y+1,x+44,y+29);

		   setfillstyle(1,1);
		     bar(x+46,y+1,x+59,y+29);

		   setcolor(15);
		     line(x+45,y,x+45,y+30);

		   setcolor(11);
		   settextstyle(0,0,1);
		     outtextxy(x+3,y+10,element);

		   if(count==inserted_element_count-1)
		      {
			 setcolor(15);
			 outtextxy(x+50,y+11,"x");
		      }
		}

	     else
		{
		   setfillstyle(1,9);
		     bar(x+16,y+1,x+59,y+29);

		   setfillstyle(1,1);
		     bar(x+1,y+1,x+14,y+29);

		   setcolor(15);
		     line(x+15,y,x+15,y+30);

		   setcolor(11);
		   settextstyle(0,0,1);
		     outtextxy(x+18,y+10,element);

		   if(count==inserted_element_count-1)
		      {
			 setcolor(15);
			 outtextxy(x+4,y+11,"x");
		      }
		}

	     if(count==1 || count==2 || count==7 || count==8 || count==13
								|| count==14)
		{
		   setcolor(15);
		     line(x-45,y+15,x,y+15);

		   setfillstyle(1,15);
		     pieslice(x-47,y+15,0,360,2);

		     line(x-6,y+11,x-2,y+15);
		     line(x-6,y+19,x-2,y+15);
		}

	     else if(count==4 || count==5 || count==10 || count==11)
		{
		   setcolor(15);
		     line(x+60,y+15,x+105,y+15);

		   setfillstyle(1,15);
		     pieslice(x+107,y+15,0,360,2);

		     line(x+66,y+11,x+62,y+15);
		     line(x+66,y+19,x+62,y+15);
		}

	     else if(count==3 || count==9)
		{
		   setcolor(15);
		     setfillstyle(1,15);
		       pieslice(x+53,y-45,0,360,2);

		     setlinestyle(0,0,3);
		       line(x+55,y-45,x+75,y-45);
		       line(x+75,y-45,x+75,y+15);
		       line(x+60,y+15,x+75,y+15);

		       line(x+62,y+15,x+66,y+11);
		       line(x+62,y+15,x+66,y+19);
		}

	     else if(count==6 || count==12)
		{
		   setcolor(15);
		     setfillstyle(1,15);
		       pieslice(x+7,y-45,0,360,2);

		     setlinestyle(0,0,3);
		       line(x-15,y-45,x+10,y-45);
		       line(x-15,y-45,x-15,y+15);
		       line(x-15,y+15,x,y+15);

		       line(x-2,y+15,x-6,y+11);
		       line(x-2,y+15,x-6,y+19);
		}

	     setcolor(7);
	     setlinestyle(0,0,3);
	       line(350,125,350,138);  /* Bottom Arrow */
	       line(346,134,350,138);
	       line(354,134,350,138);

	     setcolor(14);
	     settextstyle(2,0,4);
	       outtextxy(332,140,"Front");

	     if(count==inserted_element_count-1)
		{
		   setcolor(7);
		   setlinestyle(0,0,3);
		    line(x+30,y+25,x+30,y+38);
		    line(x+26,y+34,x+30,y+38);
		    line(x+34,y+34,x+30,y+38);

		   setcolor(14);
		   settextstyle(2,0,4);
		     outtextxy(x+30,y+40,"Rear");
		}

	     print=print->next;
	     count++;

	     if(count==0 || count==1 || count==2 || count==6 || count==7 ||
			     count==8 || count==12 || count==13 || count==14)
		x+=100;

	     else if(count==3 || count==4 || count==5 || count==9 ||
		     count==10 ||  count==11)
		x-=100;

	     if(count==3 || count==9)
		{
		   x=540;
		   y+=60;
		}

	     else if(count==6 || count==12)
		{
		   x=340;
		   y+=60;
		}

	      if(count==15)
		 break;
	  }

       setlinestyle(0,0,0);
    }

 /**************************************************************************/
 //------------------------  waiting_for_input( )  ------------------------//
 /**************************************************************************/

 void Linked_list_Queue ::waiting_for_input( )
    {
       do
	  {
	     setfillstyle(1,4);
	       bar(51,440,99,445);

	     setfillstyle(1,10);
	       bar(101,440,149,445);

	     setfillstyle(1,1);
	       bar(151,440,199,445);

	     setfillstyle(1,14);
	       bar(201,440,249,445);

	     delay(300);

	     setfillpattern(fill_pattern,9);
	       bar(51,440,99,445);

	     delay(150);

	       bar(101,440,149,445);

	     delay(150);

	       bar(151,440,199,445);

	     delay(150);

	       bar(201,440,249,445);

	     delay(150);

	     setfillstyle(1,4);
	       bar(51,440,99,445);

	     delay(150);

	     setfillstyle(1,10);
	       bar(101,440,149,445);

	     delay(150);

	     setfillstyle(1,1);
	       bar(151,440,199,445);

	     delay(150);

	     setfillstyle(1,14);
	       bar(201,440,249,445);
	  }
       while(!kbhit( ));

       setfillpattern(fill_pattern,9);
	 bar(51,440,249,445);
    }

 /**************************************************************************/
 //---------------------------  show_working( )  --------------------------//
 /**************************************************************************/

 void Linked_list_Queue ::show_working( )
    {
       show_main_screen( );
       delay(1000);
       show_linked_list_screen( );

       char ch;

       do
	  {
	     waiting_for_input( );
	     ch=getch( );

	     switch(ch)
		{
		   case 'i': Insert( );
			     break;

		   case 'I': Insert( );
			     break;

		   case 'd': Delete( );
			     break;

		   case 'D': Delete( );
			     break;

		   case 'e': delay(500);
			     exit(0);

		   case 'E': delay(500);
			     exit(0);
		}
	  }
       while(int(ch)!=27);

       delay(500);
    }

 /**************************************************************************/
 /**************************************************************************/
 //--------------------------------  main( )  -----------------------------//
 /**************************************************************************/
 /**************************************************************************/

 main( )
    {
       int driver=VGA;
       int mode=VGAHI;

       initgraph(&driver,&mode,"..\\Bgi");

       Linked_list_Queue  obj;

       obj.show_working( );

       closegraph( );

       return 0;
    }

 /**************************************************************************/
 /**************************************************************************/
 //------------------------------  THE END  -------------------------------//
 /**************************************************************************/
 /**************************************************************************/