
 /*************************************************************************/
 /*************************************************************************

 NA-08 : A C++ Program to read a Non-Linear equation in one variable, then
	 evaluate it using Newton-Raphson Method and display its kD accurate
	 root.

  *************************************************************************/
 /*************************************************************************/
 /*************************************************************************

	  By :
		Muhammad Tahir Shahzad  [ MTS ]
		B.C.S Honours  [ 2000-04 ]
		Government College University Lahore
		Pakistan

      E-mail :  mtshome@wol.net.pk

    Web-Site :  www.mts-home.cjb.net  [ www.wol.net.pk/mtshome ]
		www.mtshome.cjb.net   [ www.geocities.com/mtahirshahzad ]

  *************************************************************************/

 /*************************************************************************/
 /*************************************************************************/
 //--------------------------  Header Files  -----------------------------//
 /*************************************************************************/
 /*************************************************************************/

 # include <iostream.h>
 # include <string.h>
 # include <stdlib.h>
 # include <conio.h>
 # include <math.h>

 /*************************************************************************/
 /*************************************************************************/
 //-------------------------  Global Variables  --------------------------//
 /*************************************************************************/
 /*************************************************************************/

 const int max_size=30;

 int top=-1;
 int accuracy=0;
 int iterations=0;

 long double x0=0;
 long double xn=0;

 char Non_linear_equation[100]={NULL};
 char Differential_non_linear_equation[100]={NULL};
 char Stack[max_size][max_size]={NULL};
 char Postfix_expression[2][max_size][max_size]={NULL};

 /*************************************************************************/
 /*************************************************************************/
 //-----------------------  Function Prototypes  -------------------------//
 /*************************************************************************/
 /*************************************************************************/

 void push(const char *);
 void convert_infix_expression_to_postfix_expression(const char *,const int);

 const char* pop( );
 const long double evaluate_postfix_expression(const long double,const int);

 void show_screen( );
 void clear_screen( );
 void get_input( );
 void apply_newton_raphson_method( );
 void show_result( );

 /*************************************************************************/
 /*************************************************************************/
 //------------------------------  main( )  ------------------------------//
 /*************************************************************************/
 /*************************************************************************/

 int main( )
    {
       clrscr( );
       textmode(C4350);

       show_screen( );
       get_input( );
       apply_newton_raphson_method( );
       show_result( );

       getch( );
       return 0;
    }

 /*************************************************************************/
 /*************************************************************************/
 //----------------------  Function Definitions  -------------------------//
 /*************************************************************************/
 /*************************************************************************/

 /*************************************************************************/
 //--------------------------  push(const char*)  ------------------------//
 /*************************************************************************/

 void push(const char* Operand)
    {
       if(top==(max_size-1))
	  {
	     cout<<"Error : Stack is full."<<endl;
	     cout<<"\n        Press any key to exit.";

	     getch( );
	     exit(0);
	  }

       else
	  {
	     top++;
	     strcpy(Stack[top],Operand);
	  }
    }

 /*************************************************************************/
 //------------------------------  pop( )  -------------------------------//
 /*************************************************************************/

 const char* pop( )
    {
       char Operand[40]={NULL};

       if(top==-1)
	  {
	     cout<<"Error : Stack is empty."<<endl;
	     cout<<"\n        Press any key to exit.";

	     getch( );
	     exit(0);
	  }

       else
	  {
	     strcpy(Operand,Stack[top]);
	     strset(Stack[top],NULL);
	     top--;
	  }

       return Operand;
    }

 /*************************************************************************/
 /*----  convert_infix_expression_to_postfix_expression(
					      const char*,const int)  ----*/
 /*************************************************************************/

 void convert_infix_expression_to_postfix_expression(
				     const char* Expression,const int flag)
    {
       char Infix_expression[100]={NULL};
       char Symbol_scanned[30]={NULL};

       push("(");
       strcpy(Infix_expression,Expression);
       strcat(Infix_expression,"+0)");

       int operator_operand=0;
       int count_1=0;
       int count_2=0;
       int equation_length=strlen(Infix_expression);

       if(Infix_expression[0]=='(')
	  operator_operand=1;

       do
	  {
	     strset(Symbol_scanned,NULL);

	     if(operator_operand==0)
		{
		   int count_3=0;

		   do
		      {
			 Symbol_scanned[count_3]=Infix_expression[count_1];

			 count_1++;
			 count_3++;
		      }
		   while(count_1<=equation_length &&
			   Infix_expression[count_1]!='(' &&
			      Infix_expression[count_1]!='+' &&
				 Infix_expression[count_1]!='-' &&
				    Infix_expression[count_1]!='*' &&
				       Infix_expression[count_1]!='/' &&
					  Infix_expression[count_1]!='^' &&
					     Infix_expression[count_1]!=')');


		   operator_operand=1;
		}

	     else if(operator_operand==1)
		{
		   Symbol_scanned[0]=Infix_expression[count_1];

		   count_1++;

		   if(Infix_expression[count_1]!='(' &&
			 Infix_expression[count_1]!='^' &&
			    Infix_expression[count_1]!='*' &&
			       Infix_expression[count_1]!='/' &&
				  Infix_expression[count_1]!='+' &&
				     Infix_expression[count_1]!='-' &&
					Infix_expression[count_1]!=')')
		      operator_operand=0;

		   if(Infix_expression[count_1-1]=='(' &&
			   (Infix_expression[count_1]=='-' ||
				 Infix_expression[count_1]=='+'))
		      operator_operand=0;
		}

	     if(strcmp(Symbol_scanned,"(")==0)
		push("(");

	     else if(strcmp(Symbol_scanned,")")==0)
		{
		   while(strcmp(Stack[top],"(")!=0)
		      {
			 strcpy(Postfix_expression[flag][count_2],pop( ));

			 count_2++;
		      }

		   pop( );
		}

	     else if(strcmp(Symbol_scanned,"^")==0 ||
			   strcmp(Symbol_scanned,"+")==0 ||
				 strcmp(Symbol_scanned,"-")==0 ||
				       strcmp(Symbol_scanned,"*")==0 ||
					     strcmp(Symbol_scanned,"/")==0)
		{
		   if(strcmp(Symbol_scanned,"^")==0)
		      {  }

		   else if(strcmp(Symbol_scanned,"*")==0 ||
					      strcmp(Symbol_scanned,"/")==0)
		      {
			 while(strcmp(Stack[top],"^")==0 ||
				     strcmp(Stack[top],"*")==0 ||
					   strcmp(Stack[top],"/")==0)
			    {
			       strcpy(Postfix_expression[flag][count_2],pop( ));

			       count_2++;
			    }
		      }

		   else if(strcmp(Symbol_scanned,"+")==0 ||
				    strcmp(Symbol_scanned,"-")==0)
		      {
			 while(strcmp(Stack[top],"(")!=0)
			    {
			       strcpy(Postfix_expression[flag][count_2],pop( ));

			       count_2++;
			    }
		      }

		   push(Symbol_scanned);
		}

	     else
		{
		   strcat(Postfix_expression[flag][count_2],Symbol_scanned);

		   count_2++;
		}
	  }
       while(strcmp(Stack[top],NULL)!=0);

       strcat(Postfix_expression[flag][count_2],"=");
       count_2++;
    }

 /*************************************************************************/
 //-----  evaluate_postfix_expression(const long double,const int)  ------//
 /*************************************************************************/

 const long double evaluate_postfix_expression(const long double x,
							      const int flag)
    {
       long double function_value=0;

       int count_1=-1;

       char Symbol_scanned[30]={NULL};

       do
	  {
	     count_1++;

	     strcpy(Symbol_scanned,Postfix_expression[flag][count_1]);

	     if(strcmp(Symbol_scanned,"^")==0 ||
		      strcmp(Symbol_scanned,"*")==0 ||
			    strcmp(Symbol_scanned,"/")==0 ||
				  strcmp(Symbol_scanned,"+")==0 ||
					strcmp(Symbol_scanned,"-")==0)

		{
		   char Result[30]={NULL};
		   char Operand[2][30]={NULL};

		   strcpy(Operand[0],pop( ));
		   strcpy(Operand[1],pop( ));

		   long double operand[2]={0};
		   long double result=0;

		   char *endptr;

		   for(int count_2=0;count_2<2;count_2++)
		      {
			 int flag=0;

			 if(Operand[count_2][0]=='-')
			    {
			       int length=strlen(Operand[count_2]);

			       for(int count_3=0;count_3<(length-1);count_3++)
				  Operand[count_2][count_3]=Operand[count_2][(count_3+1)];

			       Operand[count_2][count_3]=NULL;

			       flag=1;
			    }

			 if(strcmp(Operand[count_2],"x")==0)
			    operand[count_2]=x;

			 else if(strcmp(Operand[count_2],"e")==0)
			    operand[count_2]=2.718282;

			 else if(strcmp(Operand[count_2],"sinx")==0)
			    operand[count_2]=sinl(x);

			 else if(strcmp(Operand[count_2],"cosx")==0)
			    operand[count_2]=cosl(x);

			 else if(strcmp(Operand[count_2],"tanx")==0)
			    operand[count_2]=tanl(x);

			 else if(strcmp(Operand[count_2],"lnx")==0)
			    operand[count_2]=logl(x);

			 else if(strcmp(Operand[count_2],"logx")==0)
			    operand[count_2]=log10l(x);

			 else
			    operand[count_2]=strtod(Operand[count_2],&endptr);

			 if(flag)
			    operand[count_2]*=-1;
		      }

		   switch(Symbol_scanned[0])
		      {
			 case '^' : result=powl(operand[1],operand[0]);
				    break;

			 case '*' : result=operand[1]*operand[0];
				    break;

			 case '/' : result=operand[1]/operand[0];
				    break;

			 case '+' : result=operand[1]+operand[0];
				    break;

			 case '-' : result=operand[1]-operand[0];
				    break;
		      }

		   gcvt(result,25,Result);

		   push(Result);
		}

	     else if(strcmp(Symbol_scanned,"=")!=0)
		push(Symbol_scanned);
	  }
       while(strcmp(Symbol_scanned,"=")!=0);

       char Function_value[30]={NULL};
       char *endptr;

       strcpy(Function_value,pop( ));
       function_value=strtod(Function_value,&endptr);

       return function_value;
    }

 /*************************************************************************/
 //--------------------------  show_screen( )  ---------------------------//
 /*************************************************************************/

 void show_screen( )
    {
       cprintf("\n********************************************************************************");
       cprintf("**************************-                         -***************************");
       cprintf("*-------------------------- ");

       textbackground(1);
       cprintf(" Newton-Raphson Method ");
       textbackground(8);

       cprintf(" ---------------------------*");
       cprintf("**************************-                         -***************************");
       cprintf("********************************************************************************");

       for(int count=0;count<42;count++)
	  cprintf("*                                                                              *");

       gotoxy(1,46);
       cprintf("********************************************************************************");
       cprintf("*------------------------------------------------------------------------------*");
       cprintf("********************************************************************************");

       gotoxy(1,2);
    }

 /*************************************************************************/
 //-------------------------  clear_screen( )  ---------------------------//
 /*************************************************************************/

 void clear_screen( )
    {
       for(int count=0;count<37;count++)
	  {
	     gotoxy(3,8+count);
	     cout<<"                                                                            ";
	  }

       gotoxy(1,2);
    }

 /*************************************************************************/
 //---------------------------- get_input( )  ----------------------------//
 /*************************************************************************/

 void get_input( )
    {
       gotoxy(4,11);
       cout<<"Non-Linear Equation with One Variable:";

       gotoxy(4,12);
       cout<<"";

       gotoxy(6,37);
       cout<<"Note : Write the function with proper Braces ( ) e.g; 2x+3 as (2*x)+3";

       gotoxy(6,40);
       cout<<"Available Operators  :  ^ (raised to power) , * , / , + , -";

       gotoxy(6,42);
       cout<<"Available Operands   :  x , e , sinx , cosx , tanx , lnx , logx ,";

       gotoxy(6,44);
       cout<<"                        n = any number";

       gotoxy(4,15);
       cout<<"Enter the Function with variabel x = f(x) = ";
       cin>>Non_linear_equation;

       gotoxy(4,18);
       cout<<"Enter the Differential Function = f'(x) = ";
       cin>>Differential_non_linear_equation;

       gotoxy(4,24);
       cout<<"Enter the Starting value = x0 = ";
       cin>>x0;

       gotoxy(4,27);
       cout<<"Enter the number of accuracy required = k =  ";
       cin>>accuracy;

       gotoxy(1,2);
    }

 /*************************************************************************/
 //------------------  apply_newton_raphson_method( )  -------------------//
 /*************************************************************************/

 void apply_newton_raphson_method( )
    {
       clear_screen( );

       gotoxy(4,10);
       cout<<"Solution :";

       gotoxy(4,11);
       cout<<"";

       convert_infix_expression_to_postfix_expression(Non_linear_equation,0);
       convert_infix_expression_to_postfix_expression(Differential_non_linear_equation,1);

       long double k=0.5;

       for(int count_1=1;count_1<=accuracy;count_1++)
	  k*=0.1;

       gotoxy(4,13);
       cout<<"Ŀ";

       gotoxy(4,14);
       cout<<"n     Xn-1       f(Xn-1)      f'(Xn-1)        Xn        Accuracy   ";

       gotoxy(4,15);
       cout<<"Ĵ";

       gotoxy(4,16);
       cout<<"                                                                   ";

       long double old_x=0;
       long double new_x=x0;
       long double dfx=0;
       long double fx=0;

       int count_2=1;
       int x_cord=4;
       int y_cord=17;

       do
	  {
	     gotoxy(x_cord,y_cord);
	     cout<<"                                                                   ";

	     gotoxy(x_cord,(y_cord+1));
	     cout<<"                                                                   ";

	     old_x=new_x;

	     fx=evaluate_postfix_expression(new_x,0);
	     dfx=evaluate_postfix_expression(new_x,1);
	     new_x=(new_x-(fx/dfx));

	     gotoxy((x_cord+1),y_cord);
	     cout<<count_2;

	     gotoxy((x_cord+4),y_cord);
	     cout<<old_x;

	     gotoxy((x_cord+18),y_cord);
	     cout<<fx;

	     gotoxy((x_cord+32),y_cord);
	     cout<<dfx;

	     gotoxy((x_cord+46),y_cord);
	     cout<<new_x;

	     gotoxy((x_cord+60),y_cord);
	     cout<<fabs(new_x-old_x);

	     y_cord+=2;

	     if((count_2%12)==0 && fabs(new_x-old_x)>k)
		{
		   y_cord=17;

		   gotoxy(30,44);
		   cout<<"Press any key to continue...";
		   getch( );

		   for(int count_3=1;count_3<25;count_3++)
		      {
			 gotoxy(3,(16+count_3));
			 cout<<"                                                                            ";
		      }
		}

	     count_2++;
	     iterations++;
	  }
       while(fabs(new_x-old_x)>k);

       gotoxy(x_cord,y_cord);
       cout<<"";

       xn=new_x;

       gotoxy(30,44);
       cout<<"Press any key to continue...";
       getch( );

    }

 /*************************************************************************/
 //---------------------------  show_result( )  --------------------------//
 /*************************************************************************/

 void show_result( )
    {
       clear_screen( );

       gotoxy(6,10);
       cout<<"Function of Non-Linear Equation :";

       gotoxy(6,11);
       cout<<"";

       gotoxy(10,13);
       cout<<"f(x)  =  "<<Non_linear_equation;

       gotoxy(6,18);
       cout<<"Differential Function of the Non-Linear Equation :";

       gotoxy(6,19);
       cout<<"";

       gotoxy(10,21);
       cout<<"f'(x)  =  "<<Differential_non_linear_equation;

       gotoxy(6,25);
       cout<<"Starting Value = x0 =  "<<x0;

       gotoxy(6,27);
       cout<<"Accuracy Required = kD =  "<<accuracy<<"D";

       gotoxy(6,32);
       cout<<"Required Root :";

       gotoxy(6,33);
       cout<<"";

       gotoxy(10,35);
       cout<<"x  =  "<<xn;

       gotoxy(10,37);
       cout<<"Number of Iterations  =  "<<iterations;

       gotoxy(1,2);
    }


 /*************************************************************************/
 /*************************************************************************/
 //-----------------------------  THE END  -------------------------------//
 /*************************************************************************/
 /*************************************************************************/